<?php

namespace Drupal\matone_vacancy\Importer;

use Drupal\matone_vacancy\Importer\Operation\CreateOperation;
use Drupal\matone_vacancy\Importer\Operation\UpdateOperation;
use Drupal\matone_vacancy\ImporterInterface;
use Drupal\matone_vacancy\ImportResult;
use Drupal\matone_vacancy\PipelineFactory;
use Drupal\matone_vacancy\ResultInterface;

/**
 * Class VacancyImporter
 *
 * Handles the import of the vacancies.
 *
 * @author Sander Boelhouwers <sander.boelhouwers@ara.nl>
 */
class VacancyImporter implements ImporterInterface {

  protected const PIPELINE = [
    'importer.operation.map',
    'importer.operation.split',
    UpdateOperation::class,
    CreateOperation::class,
    'importer.operation.clean'
  ];

  /**
   * @var ResultInterface
   */
  protected $result;

  /**
   * @var PipelineFactory
   */
  protected $pipelineFactory;

  /**
   * Constructor.
   *
   * @param PipelineFactory $pipelineFactory
   */
  public function __construct(PipelineFactory $pipelineFactory) {
    $this->pipelineFactory = $pipelineFactory;
  }

  /**
   * @inheritdoc
   */
  public function getResult() {
    if (!$this->result) {
      $this->result = new ImportResult();
    }
    return $this->result;
  }

  /**
   * @inheritdoc
   */
  public function import(array $data) {
    $passable = [
      'data'   => $data,
      'result' => $this->getResult()
    ];
    $pipeline = $this->pipelineFactory->get();
    $result = $pipeline
      ->send($passable)
      ->through(self::PIPELINE)
      ->then(function ($passable) {
        return $passable['result'] ?? NULL;
      });
    return $result;
  }
}
