<?php

namespace Drupal\matone_vacancy\Importer\Operation;

use Drupal\Core\Entity\EntityStorageException;
use Drupal\matone_vacancy\PipeInterface;
use Drupal\matone_vacancy\ResultInterface;
use Drupal\node\Entity\Node;

/**
 * Class UpdateOperation
 *
 * @author Sander Boelhouwers <sander.boelhouwers@ara.nl>
 */
class UpdateOperation implements PipeInterface {

  /**
   * @inheritdoc
   */
  public function handle($data, \Closure $next) {
    $update_data = $data['data']['update'];
    /** @var ResultInterface $result */
    $result = $data['result'];

    $updates = $result->getUpdates();
    $failed = $result->getFailed();
    foreach ($update_data as $update_info) {
      /** @var Node $node */
      $node = $update_info['node'];
      $new_data = $update_info['data'];

      foreach ($new_data as $field => $value) {
        $node->set($field, $value);
      }
      try {
        $node->save();
        $updates[] = $node;
      } catch (EntityStorageException $e) {
        $failed[] = $node;
      }
    }

    $result->setFailed($failed)
      ->setUpdates($updates);

    return $next($data);
  }
}
