<?php

namespace Drupal\matone_vacancy\Importer\Operation;

use Drupal\Component\Plugin\Exception\InvalidPluginDefinitionException;
use Drupal\Component\Plugin\Exception\PluginNotFoundException;
use Drupal\Core\Entity\EntityStorageInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\matone_vacancy\PipeInterface;

/**
 * Class SplitOperation
 *
 * Split the data in data that should be updated or data that should be created.
 *
 * @author Sander Boelhouwers <sander.boelhouwers@ara.nl>
 */
class SplitOperation implements PipeInterface {

  /**
   * @var EntityStorageInterface
   */
  protected $nodeStorage;

  /**
   * Constructor.
   *
   * @param EntityTypeManagerInterface $entityTypeManager
   *
   * @throws InvalidPluginDefinitionException
   * @throws PluginNotFoundException
   */
  public function __construct(EntityTypeManagerInterface $entityTypeManager) {
    $this->nodeStorage = $entityTypeManager->getStorage('node');
  }

  /**
   * @inheritdoc
   */
  public function handle($data, \Closure $next) {
    $vacancies = [];
    foreach ($data['data'] as $vacancy) {
      $vacancies[$vacancy['field_vacancy_id']] = $vacancy;
    }

    $vacancy_ids = array_keys($vacancies);
    $existing_nodes = $this->nodeStorage->loadByProperties(['field_vacancy_id' => $vacancy_ids]);

    $update = [];
    foreach ($existing_nodes as $node) {
      $id = $node->get('field_vacancy_id')->value;
      if (isset($vacancies[$id])) {
        $update[] = [
          'node' => $node,
          'data' => $vacancies[$id]
        ];
        unset($vacancies[$id]);
      }
    }

    $data['data'] = [
      'update' => $update,
      'create' => $vacancies
    ];

    return $next($data);
  }
}
