<?php

namespace Drupal\matone_vacancy\Plugin\Mapping;

use Drupal\matone_vacancy\Plugin\MappingBase;

/**
 * @Mapping(
 *   id = "textfield_mapping"
 * )
 */
class TextfieldMapping extends MappingBase {

  /**
   * @inheritdoc
   */
  public function map($data) {
    if (!$data) {
      return '';
    }

    return [
      'value' => html_entity_decode($data),
      'format' => 'rich_text'
    ];
  }
}
