<?php

namespace Drupal\matone_helpers;

use Drupal\Core\Datetime\DrupalDateTime;

class TimedLock {

  protected static $lockPrefix = 'time_lock:';

  public static function getLock(string $name, int $duration=60):bool {
    $lockKey = self::$lockPrefix . $name;
    $lockData = \Drupal::state()->get($lockKey);
    $currentTime = (new DrupalDateTime())->getTimestamp();
    if (!empty($lockData)) {
      if ($currentTime < $lockData['expires']) {
        return FALSE;
      }
    }
    $lockData = [
      'acquired' => $currentTime,
      'expires' => $currentTime + $duration,
    ];
    \Drupal::state()->set($lockKey, $lockData);
    return TRUE;
  }

  public static function release(string $name) {
    $lockKey = self::$lockPrefix . $name;
    \Drupal::state()->delete($lockKey);
  }

  public static function isLocked(string $name) {
    $lockKey = self::$lockPrefix . $name;
    $lockData = \Drupal::state()->get($lockKey);
    if ($lockData) {
      $currentTime = (new DrupalDateTime())->getTimestamp();
      return $currentTime < $lockData['expires'];
    }
    return FALSE;
  }
}