<?php

namespace Drupal\mapping_service\EntityFields;

use Drupal\mapping_service\Contract\EntityFieldInterface;

class WysiwygField implements EntityFieldInterface {

  private string $format = 'wysiwyg';

  public function __construct(...$options) {
    if ($options['format']) {
      $this->format = $options['format'];
    }
  }


  public function map(mixed $value): array {
    if (empty($value)) {
      return [];
    }
    return [
      'format' => $this->format,
      'value' => check_markup(html_entity_decode($value), $this->format),
    ];
  }

}
