<?php

namespace Drupal\mapping_service\Concerns;

use Drupal\Core\Form\FormStateInterface;

trait FromFormState {
  public static function FromFormState(FormStateInterface $formState, $cleanup = TRUE): static {
    if ($cleanup) {
      $formState->cleanValues();
    }
    $formValues = $formState->getValues();

    if ($formState->hasFileElement()){
      foreach ($formValues['files'] as $key => $file) {
        $formValues[$key] = $file;
      }
    }
    $object = new static();
    $object->fill($formValues);
    return $object;
  }
}
