<?php

namespace Drupal\mapping_service\Concerns;

use Drupal\mapping_service\Attribute\EntityField;
use Drupal\mapping_service\Attribute\isTranslatable;
use ReflectionClass;

trait AsEntityFields {

  public function getFieldData(): array {
    $reflection = new ReflectionClass($this);
    if ($reflection->hasProperty('hasLanguages')) {
      $result = [];
      foreach (self::$hasLanguages as $language) {
        $result[$language] = $this->mapFields($reflection, $language);
      }
      return $result;
    }
    return $this->mapFields($reflection);
  }

  protected function mapFields(ReflectionClass $reflection, $language = FALSE): array {
    $result = [];
    foreach ($reflection->getProperties() as $property) {
      $entityFields = $property->getAttributes(EntityField::class);
      $isTranslatable = (!empty($property->getAttributes(isTranslatable::class)));
      foreach ($entityFields as $entityField) {
        /** @var EntityField $handler */
        $mappedValues = null;
        $handler = $entityField->newInstance();
        $value = $this->getAttribute($property->getName());
        if ($language && $isTranslatable && is_array($value)) {
          $value = $value[$language] ?? NULL;
          $fieldHandler = $handler->getFieldHandler();
          if ($fieldHandler && method_exists($fieldHandler,'setLanguage')){
            $fieldHandler->setLanguage($language);
          }
        }

        $mappedValues = $handler->getMappedValues($value);
        if (!empty($mappedValues)) {
          $result = [...$result, ...$mappedValues];
        }
      }
    }
    return $result;
  }
}
