<?php

declare(strict_types=1);

namespace Drupal\mapping_service\Abstract;

use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\mapping_service\Contract\EntityMappingInterface;
use Drush\Log\DrushLoggerManager;
use Psr\Log\LoggerInterface;

/**
 * Base class for entity_mapping plugins.
 */
abstract class EntityMappingPluginBase extends PluginBase implements EntityMappingInterface {
  use StringTranslationTrait;
  private DrushLoggerManager|LoggerInterface|null $logger = NULL;

  public function __construct(array $configuration, $plugin_id, $plugin_definition) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    if ($configuration['logger']) {
      $this->logger = $configuration['logger'];
    }
  }

  public function getLogger(): LoggerInterface|DrushLoggerManager {
    if (!$this->logger) {
      $this->logger = \Drupal::logger('matone_services');
    }
    return $this->logger;
  }

  public function label(): string {
    // Cast the label to a string since it is a TranslatableMarkup object.
    return (string) $this->pluginDefinition['label'];
  }

  abstract public function run();
}
