<?php

declare(strict_types=1);

namespace Drupal\mapping_service\Service;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\mapping_service\Attribute\EntityMapping;
use Drupal\mapping_service\Contract\EntityMappingInterface;

/**
 * EntityMapping plugin manager.
 */
final class EntityMappingPluginManager extends DefaultPluginManager {

  /**
   * Constructs the object.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/EntityMapping', $namespaces, $module_handler, EntityMappingInterface::class, EntityMapping::class);
    $this->alterInfo('entity_mapping_info');
    $this->setCacheBackend($cache_backend, 'entity_mapping_plugins');
  }

}
