<?php

namespace Drupal\mapping_service\EntityFields;

use Drupal;
use Drupal\Core\Entity\EntityStorageInterface;
use Drupal\mapping_service\Contract\EntityFieldInterface;
use Drupal\mapping_service\Contract\LanguageAwareEntityField;
use Drupal\taxonomy\Entity\Term;
use InvalidArgumentException;

class TaxonomyTerm implements EntityFieldInterface,LanguageAwareEntityField {

  protected string $vid;

  protected bool $hasMachineName = FALSE;

  protected EntityStorageInterface $termStorage;

  protected ?string $language = null;

  public function __construct(...$options) {
    if (!$options['vid']) {
      throw new InvalidArgumentException('vid can not be empty');
    }
    $this->vid = $options['vid'];

    if ($options['machine_name']) {
      $this->hasMachineName = $options['machine_name'];
    }
    $this->termStorage = Drupal::entityTypeManager()->getStorage('taxonomy_term');
  }

  public function setLanguage($language){
    $this->language = $language;
  }

  public function map(mixed $value): array {
    $return = [];
    if (!empty($value)) {
      if (is_array($value)) {
        foreach ($value as $item) {
          $term = $this->getTaxonomyTerm($item);
          $return[] = $term->id();
        }
      }
      else {
        $term = $this->getTaxonomyTerm($value);
        $return[] = $term->id();
      }
    }
    return $return;
  }

  protected function getTaxonomyTerm($value): Term {
    $properties = ['vid' => $this->vid, 'name' => $value];
    $term = $this->loadByProperties($properties);
    if (!$term) {
        if ($this->language) {
          $properties['langcode'] = $this->language;
        }
      $term = $this->termStorage->create($properties);
      $term->save();
      return $term;
    }
    if ($this->language){
      if ($term->hasTranslation($this->language)){
        $term = $term->getTranslation($this->language);
      } else {
        $term->addTranslation($this->language);
        $term->setName($value);
        $term->save();
      }
    }
    return $term;
  }

  protected function loadByProperties($properties): ?Term {
    $term = $this->termStorage->loadByProperties($properties);
    if ($term) {
      return reset($term);
    }
    return NULL;
  }
}
