<?php
namespace Drupal\mapping_service\Commands;

use AllowDynamicProperties;
use Drupal\mapping_service\Service\EntityMappingPluginManager;
use Drush\Attributes as CLI;
use Drush\Commands\AutowireTrait;
use Drush\Commands\DrushCommands;
use Exception;
use Drupal\matone_helpers\TimedLock;

#[AllowDynamicProperties]
class MappingServiceCommands extends DrushCommands {

  use AutowireTrait;

  /**
   * Constructs a MappingServiceCommands object.
   */
  public function __construct(
    private readonly EntityMappingPluginManager $pluginManagerEntityMapping,
  ) {
    parent::__construct();
  }

  /**
   * Run a MappingService plugin
   *
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   */
  #[CLI\Command(name: 'matone:run-mapping', aliases: ['run-mapping'])]
  #[CLI\Option('console-only', 'Only log output to console')]
  #[CLI\Argument(name: 'mapping', description: 'Name of mapping service to run.')]
  #[CLI\Usage(name: 'matone:run-mapping [mapping]', description: 'Runs the given [mapping] Plugin')]
  #[CLI\Usage(name: 'matone:run-mapping [mapping]  --console-only', description: 'Runs the given [mapping] Plugin only log output to console')]
  public function runMappingService($mapping = NULL): void {
    if (!$mapping) {
      $plugins = $this->getAvailablePlugins();
      $plugin = $this->io()->select('Select mapping to run', $plugins);
      $this->input->setArgument('mapping', $plugin);
    }
    $mapperConfig = [];
    if ($this->input()->getOption('console-only')) {
      $mapperConfig = ['logger' => $this->logger()];
    }
    $mapping = $this->input()->getArgument('mapping');
    $lock = TimedLock::getLock($mapping);
    if ($lock){
        $mapper = $this->pluginManagerEntityMapping->createInstance($mapping, $mapperConfig);
        $this->io()->section('Run : ' . $mapper->label());
        try {
            $mapper->run();
            $this->io()->info('Done');
        } catch (Exception $exception) {
            $this->io()->error($exception->getMessage());
        }
        TimedLock::release($mapping);
    }
  }

  private function getAvailablePlugins() {
    $plugins = $this->pluginManagerEntityMapping->getDefinitions();
    $pluginList = [];
    foreach ($plugins as $pluginId => $plugin) {
      $pluginList[$pluginId] = (string) $plugin['label'];
    }
    return $pluginList;
  }

}
