<?php

namespace Drupal\mapping_service\Attribute;

use Attribute;
use Drupal\mapping_service\Contract\SetValueInterface;
use InvalidArgumentException;

#[Attribute(Attribute::TARGET_PROPERTY)]
class SetValue {

  private SetValueInterface $handler;

  public function __construct(string|SetValueInterface $implementation, mixed ...$params) {
    $this->handler = $this->resolveHandler($implementation, $params);
  }

  public function getInstance(): SetValueInterface{
    return $this->handler;
  }

  private function resolveHandler(string|SetValueInterface $implementation, array $params): SetValueInterface {
    if ($implementation instanceof SetValueInterface) {
      return $implementation;
    }

    if (class_exists($implementation)) {
      $instance = new $implementation(...$params);

      if (!$instance instanceof SetValueInterface) {
        throw new InvalidArgumentException(
          sprintf('Class %s must implement SetValueInterface', $implementation)
        );
      }

      return $instance;
    }

    throw new InvalidArgumentException('Invalid SetValue implementation');
  }
}
