<?php

namespace Drupal\mapping_service\Attribute;

use Attribute;
use Drupal\mapping_service\Contract\GetValueInterface;
use InvalidArgumentException;

#[Attribute(Attribute::TARGET_PROPERTY)]
class GetValue {

  private GetValueInterface $handler;

  public function __construct(string|GetValueInterface $implementation, mixed ...$params) {
    $this->handler = $this->resolveHandler($implementation, $params);
  }

  private function resolveHandler(string|GetValueInterface $implementation, array $params): GetValueInterface {
    if ($implementation instanceof GetValueInterface) {
      return $implementation;
    }

    if (class_exists($implementation)) {
      $instance = new $implementation(...$params);

      if (!$instance instanceof GetValueInterface) {
        throw new InvalidArgumentException(
          sprintf('Class %s must implement GetValueInterface', $implementation)
        );
      }

      return $instance;
    }

    throw new InvalidArgumentException('Invalid getValue implementation');
  }

  public function getValue(mixed $rawValue): mixed {
    return $this->handler->get($rawValue);
  }
}
