<?php

namespace Drupal\lazy_responsive_image\Plugin\ImageEffect;

use Drupal\Core\Image\ImageInterface;
use Drupal\image\ImageEffectBase;

/**
 * Provides a 'BlurImageEffect' image effect.
 *
 * @ImageEffect(
 *  id = "blur_image_effect",
 *  label = @Translation("Blur image"),
 *  description = @Translation("Blur an image")
 * )
 */
class BlurImageEffect extends ImageEffectBase {

  /**
   * {@inheritdoc}
   */
  public function applyEffect(ImageInterface $image) {
    $image = $image->getToolkit()->getResource();
    if ($image){
      $success = true;
      try {
        imagefilter($image,IMG_FILTER_PIXELATE,3);
        // then blur
        imagefilter($image,IMG_FILTER_GAUSSIAN_BLUR);
      } catch (\Exception $exception){
        $success = false;
      }
      return $success;
    }
    return false;
  }
}
