<?php

namespace Drupal\graphql_layoutbuilder\Plugin\GraphQL\Fields\Sections;

use Drupal\graphql\GraphQL\Execution\ResolveContext;
use Drupal\graphql\Plugin\GraphQL\Fields\FieldPluginBase;
use Drupal\node\Entity\Node;
use GraphQL\Type\Definition\ResolveInfo;

/**
 * GraphQL does not allow types without a field.
 *
 * So the first field of the LayoutType is section_type.
 *
 * @GraphQLField(
 *   id = "layout_reference",
 *   secure = true,
 *   name = "sections",
 *   type = "[Section]",
 *   parents = {"Entity"},
 * )
 */
class Sections extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function resolveValues($value, array $args, ResolveContext $context, ResolveInfo $info) {
    if ($value instanceof Node) {
      if ($value->hasField('layout_builder__layout')) {
        /** @var \Drupal\layout_builder\Field\LayoutSectionItemList $layout */
        $layout = $value->get('layout_builder__layout');
        $sections = $layout->getIterator();

        // Set the node as a context.
        $context->setContext('entity', $value, $info);

        /** @var \Drupal\layout_builder\Plugin\Field\FieldType\LayoutSectionItem $item */
        foreach ($sections as $key => $item) {
          /** @var \Drupal\layout_builder\Section $section */
          $section = $item->section;
          // The section does not have a unique id in the database. So we have to generate one.
          // Format = NodeID + LayoutId + OrderID (weight) of section
          $section_id = implode(
            '-',
            [
              $value->id(),
              $section->getLayoutId(),
              $key + 1,
            ]
          );
          $section->setThirdPartySetting('graphql', 'key', $section_id);
          yield $section;
        }
      }
    }
    else {
      yield NULL;
    }

  }

}
