<?php

namespace Drupal\ga4_server\Drush\Commands;

use AllowDynamicProperties;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Datetime\DrupalDateTime;
use Drupal\Core\Logger\LoggerChannelInterface;
use Drupal\ga4_server\Database\EventsStorage;
use Drush\Attributes as CLI;
use Drush\Commands\AutowireTrait;
use Drush\Commands\DrushCommands;
use Error;
use Exception;

#[AllowDynamicProperties]
class Ga4ServerCommands extends DrushCommands {
  use AutowireTrait;

  protected $config;
  public function __construct(
    private readonly ConfigFactoryInterface $configFactory,
  ) {
   $this->config = $this->configFactory->get('ga4_server.settings');
   $this->eventsStorage = \Drupal::getContainer()->get('ga4_server.events_storage');
    parent::__construct();
  }

  #[CLI\Command(name: 'matone:ga-events:queue', aliases: ['mqgae','matone-queue-ga-events'])]
  public function queueEvents(): void {
    try {
      $clients_per_run = $this->config->get('clients_per_run') ?? 20;
      $this->eventsStorage->queueEventsForProcessing($clients_per_run);
    } catch (Exception|Error $e){
      $this->io()->error($e->getMessage());
    }
  }

  #[CLI\Command(name: 'matone:ga-events:cleanup', aliases: ['mqcgae','matone-cleanup-ga-events'])]
  public function cleanupEvents() {
    $current_time = new DrupalDateTime()->getTimestamp();
    $last_cleanup_time = \Drupal::state()->get('ga4_server.last_cleanup', 0);
    $cleanup_interval =   $this->config->get('cleanup_interval') ?? 86400;
    if (($current_time - $last_cleanup_time) >= $cleanup_interval) {
      $this->eventsStorage->deleteExpiredEvents();
      \Drupal::state()->set('ga4_server.last_cleanup', $current_time);
    }
  }
}
