<?php

namespace Drupal\ga4_server\Enum;

/**
 * Enum representing possible statuses for event processing.
 */
enum EventStatus: int {
  case NEW = 0;
  case QUEUED = 1;
  case PROCESSED = 2;

  /**
   * Get a human-readable label for the status.
   *
   * @return string
   *   The human-readable label.
   */
  public function label(): string {
    return match($this) {
      self::NEW => 'New',
      self::QUEUED => 'Queued',
      self::PROCESSED => 'Processed',
    };
  }
}