<?php

namespace Drupal\ga4_server\GAEvent;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\ga4_server\Abstract\GaEventPlugin;
use Drupal\ga4_server\Attribute\GaEvent;

#[GaEvent(
  id: 'form-submit',
  label: new TranslatableMarkup('FormSubmit'),
  description: new TranslatableMarkup('Register a form submit.'),
)]
class FormSubmit extends GaEventPlugin {

  public string $eventType = 'form_submit';

  public function setEventData($eventData) {
    $this->eventData = $eventData;
    $this->storeEvent();
  }

  public function getEventType(): string {
      return $this->eventType;
  }

}
