(function() {
  'use strict';

  // --- Configuration ---
  const endpointUrl = '/_stats/rc';
  function handleLinkClick(event) {
    // Find the anchor tag element that was clicked, even if the click was on a child element (like <span> or <img>)
    const linkElement = event.target.closest('a');
    if (!linkElement) {
      return;
    }

    // Get the URL the link points to
    const clickedUrl = linkElement.href;

    // Optional: Get the current page URL as context
    const sourceUrl = window.location.href;

    // Prepare the data payload to send
    const payload = {
      link_url: clickedUrl,
      page_location: sourceUrl,
      // link_text: linkElement.textContent || linkElement.innerText,
    };

    // Use navigator.sendBeacon to send the data.
    try {
      const blob = new Blob([JSON.stringify(payload)], { type: 'application/json' });

      // Attempt to send the data. sendBeacon returns true if queued, false otherwise.
      // We don't typically need to act on the return value here, as the goal
      // is fire-and-forget. The browser handles sending it.
      const beaconSent = navigator.sendBeacon(endpointUrl, blob);

      if (!beaconSent) {
        console.warn('GA4 Click Tracker: Beacon could not be queued.', payload);
      } else {
        // Optional: Log success for debugging during development
         console.log('GA4 Click Tracker: Beacon queued successfully.', payload);
      }

    } catch (error) {
      // Catch potential errors during Blob creation or if sendBeacon itself throws
      // (though it's designed to be robust).
      console.error('Register click issue', error);
    }
    // DO NOT call event.preventDefault() here.
  }

  // Add the event listener to the document body using event delegation.
  // This is more efficient than adding listeners to every single link.
  // It listens for the 'click' event during the bubbling phase.
  document.body.addEventListener('click', handleLinkClick, false);



})();