<?php

declare(strict_types=1);

namespace Drupal\ga4_server\EventSubscriber;

use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\ga4_server\GaEventPluginManager;
use Drupal\services_base\Checks;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\ViewEvent;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 * @todo Add description for this subscriber.
 */
final readonly class EntityViewEventSubscriber implements EventSubscriberInterface {

  /**
   * Constructs an EntityViewEventSubscriber object.
   */
  public function __construct(
    private RouteMatchInterface $routeMatch,
    private Checks $checks,
  ) {}

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    $events[KernelEvents::VIEW][] = ['onEventView', 1];
    return $events;
  }

  public function onEventView(ViewEvent $event) {
    if ($this->checks->anonymousHasAccess() && $this->routeMatch->getRouteName() === 'entity.node.canonical') {
      $pageView = GaEventPluginManager::getPlugin('page-view');
      $pageView?->setEventData($event);
    }
  }

}
