<?php

namespace Drupal\ga4_server\Drush\Commands;

use AllowDynamicProperties;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Datetime\DrupalDateTime;
use Drupal\ga4_server\Enum\EventStatus;
use Drush\Attributes as CLI;
use Drush\Commands\AutowireTrait;
use Drush\Commands\DrushCommands;
use Error;
use Exception;

#[AllowDynamicProperties]
class Ga4ServerCommands extends DrushCommands {
  use AutowireTrait;

  public function __construct(
    private readonly ConfigFactoryInterface $configFactory,
  ) {
   $this->eventsStorage = \Drupal::getContainer()->get('ga4_server.events_storage');
    parent::__construct();
  }

  #[CLI\Command(name: 'matone:ga-events:queue', aliases: ['mqgae','matone-queue-ga-events'])]

  public function queueEvents(): void {
    try {
      $clients_per_run = $this->configFactory->get('ga4_server.settings')->get('clients_per_run');
      $min_events_per_client = $this->configFactory->get('ga4_server.settings')->get('min_events_per_client');;
      $this->eventsStorage->queueEventsForProcessing($clients_per_run,$min_events_per_client);
    } catch (Exception|Error $e){
      $this->io()->error($e->getMessage());
    }
  }

  #[CLI\Command(name: 'matone:ga-events:cleanup', aliases: ['mqcgae','matone-cleanup-ga-events'])]
  public function cleanupEvents() {
    $current_time = new DrupalDateTime()->getTimestamp();
    $last_cleanup_time = \Drupal::state()->get('ga4_server.last_cleanup', 0);
    $cleanup_interval   = $this->configFactory->get('ga4_server.settings')->get('cleanup_interval');
    if (($current_time - $last_cleanup_time) >= $cleanup_interval) {
      $this->eventsStorage->deleteExpiredEvents();
      \Drupal::state()->set('ga4_server.last_cleanup', $current_time);
    }
  }

  #[CLI\Command(name: 'matone:ga-events:flush-single', aliases: ['mqcgaefs','matone-flush-single-events'])]
  #[CLI\Option(name: 'max-clients', description: 'The maximum number of clients to process events for in this run.')]
  #[CLI\Help('Get all the single events and send them to GA')]
  public function flushEvents(int $max_clients = 100): void {
    $eventsAboutToExpire = $this->eventsStorage->getSingleAboutToExpireEvents($max_clients);
    $ga4Client =\Drupal::getContainer()->get('ga4_server.measurement_protocol_client');
    $eventIds = [];
    foreach ($eventsAboutToExpire as $event) {
      $clientId = $event['client_id'];
      $eventIds[] = $event['ulid'];
      $ga4Client->sendEvents($clientId,[$event['events']]);
      $this->io()->writeln('Send '.$event['ulid']);
    }
    $eventsAboutToExpire = $this->eventsStorage->getSingleAboutToExpireEvents();
    $ga4Client =\Drupal::getContainer()->get('ga4_server.measurement_protocol_client');
    $eventIds = [];
    foreach ($eventsAboutToExpire as $event) {
      $clientId = $event['client_id'];
      $eventIds[] = $event['ulid'];
      $ga4Client->sendEvents($clientId,[$event['events']]);
      $this->io()->writeln('Send '.$event['ulid']);
    }
    $this->eventsStorage->setEventStatus($eventIds,EventStatus::PROCESSED);
    \Drupal::logger('ga4_server')->info('Send %count single events to GA',['%count' => count($eventIds)]);
  }
}
