<?php

namespace Drupal\ga4_server\Controller;

use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

class RegisterFingerPrint {

  public function __invoke(Request $request): JsonResponse {
    try {
      $content = $request->getContent();
      $fingerPrint = json_decode($content, TRUE, 512, JSON_THROW_ON_ERROR);
      $session = \Drupal::getContainer()->get('session');
      if (!$session->has('ga4_finger_print')){
        $session->set('ga4_finger_print',$fingerPrint['fp']);
        $session->save();
      }
    }
    catch (\Exception $exception) {
      $logger = \Drupal::getContainer()->get('logger.channel.ga4_server');
      $logger->error('Error in Fingerprint handler %error', ['%error' => $exception->getMessage()]);
    }
    return new JsonResponse(NULL, 204);
  }

}