<?php

declare(strict_types=1);

namespace Drupal\ga4_server\Controller;

use Drupal\ga4_server\GaEventPluginManager;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Returns responses for GA4 Serverside routes.
 */
final class RegisterClick {

  /**
   * Builds the response.
   */
  public function __invoke(Request $request): JsonResponse {
    $linkClicked = GaEventPluginManager::getPlugin('link-click');
    if ($linkClicked &&  $linkClicked->hasClientID()){
      try{
        $content = $request->getContent();
        $eventData = json_decode($content, TRUE, 512, JSON_THROW_ON_ERROR);
        $linkClicked->setEventData($eventData);

      } catch (\Exception $exception){
        $logger = \Drupal::getContainer()->get('logger.channel.ga4_server');
        $logger->error('Error in Click Handler %error', ['%error' => $exception->getMessage()]);
      }
    }
    return new JsonResponse(NULL, 204);
  }

}
