(function (Drupal, once) {
  'use strict';

  Drupal.behaviors.IntervalFormField = {
    attach: function (context, settings) {
      once('cleanup-interval', 'select[name="cleanup_interval[unit]"]', context).forEach(function (selectElement) {
        selectElement.addEventListener('change', function () {
          if (this.value === 'custom') {
            const customInput = document.querySelector('input[name="cleanup_interval[custom_value]"]');
            if (customInput) {
              customInput.focus();
            }
          }
        });
      });
    }
  };
})(Drupal, once);
