const { minify } = require('terser');
const fs = require('fs');

// Get input and output filenames from command line arguments
const inputFile = process.argv[2];
const outputFile = process.argv[3];

if (!inputFile || !outputFile) {
  console.error('Usage: node minify.js input.js output.min.js');
  process.exit(1);
}

// Read, minify, and write
async function processFile() {
  try {
    const code = fs.readFileSync(inputFile, 'utf8');
    const result = await minify(code, {
      compress: {
        drop_console: true,
        passes: 2
      },
      mangle: {
        toplevel: true,
      },
      format: {
        comments: false
      },
    });


    fs.writeFileSync(outputFile, result.code);
    console.log(`Minified ${inputFile} → ${outputFile}`);
  } catch (err) {
    console.error('Error:', err.message);
    process.exit(1);
  }
}

processFile().then(r => console.log('Done.') );
