<?php

declare(strict_types=1);

namespace Drupal\disable_node_route\EventSubscriber;

use Drupal\Core\Language\LanguageManagerInterface;
use Drupal\Core\Routing\RouteSubscriberBase;
use Drupal\Core\Url;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\Routing\RouteCollection;

/**
 * Route subscriber.
 */
final class DisableNodeRouteRouteSubscriber extends RouteSubscriberBase {

  public function __construct(
    private readonly LanguageManagerInterface $languageManager,
  ) {
  }

  /**
   * Constructs a DisableNodeRouteRouteSubscriber object.
   */

  public static function getSubscribedEvents(): array {
    $events[KernelEvents::REQUEST][] = ['redirectNodeUrl', 1000];
    return $events;
  }

  public function redirectNodeUrl($event) {
    $request = $event->getRequest();
    $getRequestUri = $request->getRequestUri();
    $getLanguage = $this->languageManager->getCurrentLanguage();
    $validUris = [
      '/node',
      '/' . $getLanguage->getId() . '/node',
    ];
    if (in_array($getRequestUri, $validUris)) {
      $options = [];
      if ($this->languageManager->isMultilingual()) {
        $options = ['language' => $getLanguage];
      }
      $url = Url::fromRoute('<front>', [], $options);
      $response = new RedirectResponse($url->toString());
      $response->send();
    }
  }

  protected function alterRoutes(RouteCollection $collection) {
    // nothing to Alter
  }


}
