(function (Drupal, once) {

  'use strict';

  /**
   * Enables box widget on color elements.
   *
   * @type {Drupal~behavior}
   *
   * @prop {Drupal~behaviorAttach} attach
   *   Attaches a box widget to a color input element.
   */
  Drupal.behaviors.color_element = {
    attach: function (context, settings) {
      once('colorElementSwatch', ".color-element-swatch .inner", context).forEach(function (colorSwatch) {
          colorSwatch.style.backgroundColor = colorSwatch.parentNode.dataset.swatchColor;
          colorSwatch.addEventListener('click', function () {
            const colorSwatchParent = this.parentNode;
            this.parentNode.classList.add('selected');
            Array.from(colorSwatchParent.parentNode.children).forEach(
              sibling => sibling !== colorSwatchParent && sibling.classList.remove('selected')
            );
            colorSwatchParent.parentNode.parentNode.querySelector('input').value = colorSwatchParent.dataset.swatchColor;
          });
        }
      );
      once('hideElement', ".color-element", context).forEach(function (inputElement) {
        let element = inputElement.previousElementSibling.querySelector('input');
        element.style.display = 'none';
      });
    },
  };

})(Drupal, once);
