// Legacy GTM cookies
function loadcookie(data) {
  console.warn('loadcookie() method is deprecated use cookieConsent()');
  cookieConsent();
}

function cookieConsent() {
  const cookieConsentSettings = drupalSettings.cookieConsent;
  const doNotTrack = navigator.doNotTrack === 'yes' || navigator.doNotTrack === '1' || window.doNotTrack === 'yes' || window.doNotTrack === '1';
  const showCookieBar = getCookie('cookiesaccepted') === null;

  let areCookiesAccepted = getCookie('cookiesaccepted') ?? 'false';
  let acceptedCookieTypes = getSettings();

  if (doNotTrack) {
    cookieConsentSettings.options.types.tracking.isEnabled = false;
    cookieConsentSettings.options.types.tracking.isToggable = false;
  }

  if (acceptedCookieTypes.length > 0) {
    if (!doNotTrack && acceptedCookieTypes.includes('tracking')) {
      cookieConsentSettings.options.types.tracking.isEnabled = true
    }
    if (acceptedCookieTypes.includes('analytical')){
      cookieConsentSettings.options.types.analytical.isEnabled = true;
    }
  }
  // create overlay
  let $cookieOptions = createElementWithClasses('div','cookie-options');
  let $cookieOverlay = createElementWithClasses('div','cookie-overlay', 'fixed', 'cover');
  $cookieOverlay.appendChild($cookieOptions);

  // create message
  let $cookieMessage = createElementWithClasses('div','cookie-message', 'fixed', 'left', 'all-100');
  let $cookieMessageContainer = createElementWithClasses('div','cookie-message-container');
  let $cookieMessageContainerCell = createElementWithClasses('div','cookie-message-container-cell');
  $cookieMessageContainerCell.innerHTML = cookieConsentSettings.message;

  let bodyElement = document.body;

  // The magic button or link that can be pressed by a user.
  document.querySelectorAll('.cookiesettings').forEach($optionLink => {
    $optionLink.addEventListener('click', event => {
      event.preventDefault();
      showCookieSettings();
    });
  });

  insertOptions(cookieConsentSettings.options);
  // don't show the cookie bar if the cookie settings are already set
  if (showCookieBar) {
    // create settings 'button'
    let $settingsAnchor= createElementWithClasses('a','settings');
    let settingsLabel = document.createTextNode(cookieConsentSettings.settingsLabel);
    $settingsAnchor.appendChild(settingsLabel);
    $settingsAnchor.onclick = function (event) {
      event.preventDefault();
      showCookieSettings();
    };

    // create accept button
    const $acceptAnchor = createElementWithClasses('a','button');
    const acceptLabel = document.createTextNode(cookieConsentSettings.acceptLabel);
    $acceptAnchor.appendChild(acceptLabel);
    $acceptAnchor.onclick = function (event) {
      $cookieMessage.classList.add('closed');
      saveSettings(true);
    };

    // create actions bar
    const $cookieActions = createElementWithClasses('div','actions');
    $cookieActions.appendChild($settingsAnchor);

    if (cookieConsentSettings.showDenyButton) {
      const $denyAnchor = createElementWithClasses('a','button', 'deny');
      const denyLabel = document.createTextNode(cookieConsentSettings.denyLabel);
      $denyAnchor.appendChild(denyLabel);
      $denyAnchor.onclick = function (event) {
        $cookieMessage.classList.add('closed');
        saveSettings(false);
      };
      $cookieActions.appendChild($denyAnchor);
    }
    $cookieActions.appendChild($acceptAnchor);

    if (cookieConsentSettings.showCloseButton) {
      const $closeCookieBarButton = createElementWithClasses('div','close');
      $closeCookieBarButton.innerHTML = '<div class="bar"></div><div class="bar"></div>';
      $closeCookieBarButton.onclick = function (event) {
        $cookieMessage.classList.add('closed');
        saveSettings(cookieConsentSettings.acceptOnClose);
      };
      $cookieActions.appendChild($closeCookieBarButton);
    }
    $cookieMessageContainer.appendChild($cookieMessageContainerCell);
    $cookieMessageContainer.appendChild($cookieActions);
    $cookieMessage.appendChild($cookieMessageContainer);

    // add cookie bar to container
    bodyElement.insertBefore($cookieMessage, bodyElement.firstChild);
  }

  bodyElement.insertBefore($cookieOverlay, bodyElement.firstChild);

  function showCookieSettings() {
    $cookieOverlay.style.zIndex = '999999';
    setTimeout(function () {
      $cookieOverlay.classList.add('show');
      $cookieOptions.classList.add('show');
    }, 50);
  }

  function insertOptions(options) {

    // title
    const h2 = document.createElement('h2');
    h2.innerHTML = `<strong>${options.title}</strong> | ${options.description}`;

    // close button
    const closeOverlay = document.createElement('div');

    closeOverlay.className = 'close';
    closeOverlay.innerHTML = '<div class="bar"></div><div class="bar"></div>';
    closeOverlay.onclick = function (e) {
      $cookieOverlay.classList.remove('show');
      $cookieOptions.classList.remove('show');
      setTimeout(function () {
        $cookieOverlay.style.zIndex = '-1';
      }, 500);
      saveSettings(true);
    };

    // header
    const header = document.createElement('header');
    header.appendChild(h2);
    header.appendChild(closeOverlay);

    // nav
    const optionsNav = document.createElement('nav');
    const optionsUl = document.createElement('ul');
    const optionDescriptions = createElementWithClasses('div','descriptions');

    let index = 0;
    for (const cookieType in options.types) {
      const option = options.types[cookieType];
      let activeTab = (index === 0) ? 'active' : '';
      index++;
      const optionListTitle = document.createTextNode(option.title);
      // build li
      const optionLi = document.createElement('li');
      optionLi.className = activeTab;
      optionLi.appendChild(optionListTitle);

      // add to li object
      option.tab = optionLi;

      // add listener to li
      addTabListener(option);

      // add li to ul
      optionsUl.appendChild(optionLi);

      // build description div
      const optionDescription = document.createElement('div');

      // add text
      const optionDescTitle = document.createTextNode(option.title);
      let optionDescText = document.createTextNode(option.description);
      if (doNotTrack && cookieType === 'tracking') {
        optionDescText = document.createTextNode(option.disabled_message);
      }

      const optionTextBlock = document.createElement('div');
      const optionTextBlockP = document.createElement('p');
      const optionTextBlockH3 = document.createElement('h3');

      optionTextBlockH3.appendChild(optionDescTitle);
      optionTextBlockP.appendChild(optionDescText);

      optionTextBlock.classList.add('text');
      optionTextBlock.appendChild(optionTextBlockH3);
      optionTextBlock.appendChild(optionTextBlockP);

      // add switch

      const optionSwitch = createElementWithClasses('div','switch');
      optionSwitch.classList.add(option.isEnabled ? 'on' : 'off');

      // add switch to object
      option.switch = optionSwitch;
      // add listener function to switch
      if (option.isToggable === true) {
        addSwitchListener(option);
      } else {
        optionSwitch.classList.remove('on', 'off');
        optionSwitch.classList.add('disabled');
      }
      if (option.type !== 'functional') {
        optionDescription.appendChild(optionSwitch);
      }

      // wrap up the option description
      optionDescription.appendChild(optionTextBlock);
      optionDescription.classList.add('description');

      if (activeTab !== '') {
        optionDescription.classList.add(activeTab);
      }

      // add description to object
      option.body = optionDescription;

      // add description to descriptions
      optionDescriptions.appendChild(optionDescription);
    }

    optionsNav.appendChild(optionsUl);

    // finally: build Cookie options
    $cookieOptions.appendChild(header);
    $cookieOptions.appendChild(optionsNav);
    $cookieOptions.appendChild(optionDescriptions);

    // tab handler
    function addTabListener(option) {
      option.tab.onclick = function () {
        const activeType = option.type;
        for (const cookieType in options.types) {
          if (cookieType !== activeType) {
            options.types[cookieType].tab.classList.remove('active');
            options.types[cookieType].body.classList.remove('active');
          } else {
            options.types[cookieType].tab.classList.add('active');
            options.types[cookieType].body.classList.add('active');
          }
        }
      };
    }

    // toggle switch
    function addSwitchListener(option) {
      option.switch.onclick = function () {
        if (option.isEnabled) {
          option.switch.classList.remove('on');
          option.switch.classList.add('off');
          option.isEnabled = false;
        } else {
          option.switch.classList.remove('off');
          option.switch.classList.add('on');
          option.isEnabled = true;
        }
      };
    }
  }

  function saveSettings(accepted) {
    // functional is 100% and can't be turned off.
    console.log(accepted);
    acceptedCookieTypes = ['functional'];
    for (const cookieType in cookieConsentSettings.options.types) {
      if (cookieType !== 'functional' && cookieConsentSettings.options.types[cookieType].isEnabled && accepted) {
        acceptedCookieTypes.push(cookieType);
      }
    }
    const value = JSON.stringify(acceptedCookieTypes);
    setCookie('cookiesaccepted', (accepted) ? 'true' : 'false', 120);
    setCookie('cookiesettings', value, 120);

    if (cookieConsentSettings.reloadAfterSave) {
      window.location = location;
    }
    // soft reload
    areCookiesAccepted = getCookie('cookiesaccepted');
    acceptedCookieTypes = getSettings();
    triggerDatalayer();
  }

  function getSettings() {
    let result = ['functional'];
    const currenSettings = getCookie('cookiesettings');
    if (currenSettings) {
      result = JSON.parse(currenSettings);
    }
    return result;
  }

  function setCookie(name, value, days) {

    let expires = '';
    let cookieString =  name + '=' + value;
    if (days) {
      const date = new Date();
      date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
      expires = '; Expires=' + date.toUTCString();
    }
    cookieString+=expires+'; path=/; SameSite=Lax; Domain='+getDomainName()+'; ';
    if (window.location.protocol === "https:") {
      cookieString+='Secure; '
    }
    document.cookie = cookieString;
  }

  function getCookie(cookieName) {
    const name = cookieName + '=';
    const decodedCookie = decodeURIComponent(document.cookie);
    const cookieChunks = decodedCookie.split(';').map(cookie => cookie.trim());
    let result = null;

    cookieChunks.forEach(cookie => {
      if (cookie.startsWith(name)) {
        result = cookie.substring(name.length);
      }
    });
    return result;
  }

  function deleteCookie(name){

  }

  function triggerDatalayer() {
    if (areCookiesAccepted === 'true' && (acceptedCookieTypes.includes('analytical') || acceptedCookieTypes.includes('tracking'))) {
      dataLayer.push({ 'event': 'gtmCookieTriggers'});
    }
  }

  function createElementWithClasses(elementType, ...classes) {
    const element = document.createElement(elementType);
    classes.forEach(className => element.classList.add(className));

    return element;
  }

  function getDomainName() {
    let domainName = window.location.hostname;
    if (domainName.startsWith('wwww.')){
      domainName = domainName.substring(4,domainName.length);
    }
    return '.'+domainName;
  }

}

document.addEventListener('DOMContentLoaded', function () {
  cookieConsent();
})