<?php

namespace Drupal\cookie_consent\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Cookie consent settings for this site.
 */
class CookieConsentSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'cookie_consent_cookie_consent_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['cookie_consent.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['gtm_code'] = [
      '#type' => 'textfield',
      '#title' => $this->t('GTM code'),
      '#description' => $this->t('GTM code for this domain'),
      '#placeholder' => 'GTM-XXXXXXX',
      '#required' => true,
      '#default_value' => $this->config('cookie_consent.settings')->get('gtm_code'),
    ];
    $form['enabled'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Cookie Consent and Google Tagmanager are enabled'),
      '#required' => false,
      '#default_value' => $this->config('cookie_consent.settings')->get('enabled'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    $gtmCode = $form_state->getValue('gtm_code');
    if (!preg_match('/^GTM-([A-Z0-9]{6,12})$/i',$gtmCode)) {
      $form_state->setErrorByName('gtm_code', $this->t('Invalid GTM code.'));
    }
    parent::validateForm($form, $form_state);
  }


  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $settings = $this->config('cookie_consent.settings');
      $settings->set('gtm_code', $form_state->getValue('gtm_code'));
      $settings->set('enabled',$form_state->getValue('enabled'));
      $settings->save();
    parent::submitForm($form, $form_state);
  }

}
