<?php

namespace Drupal\cookie_consent\Twig;

use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;


class CookieConsentTwigExtension extends AbstractExtension {

  public function getFunctions() {
    return [
      new TwigFunction('hasCookie', function ($type = NULL) {
        $type = strtolower($type);
        if(in_array($type, ['tracking', 'analytical','functional'])){
          $cookies = \Drupal::requestStack()->getCurrentRequest()->cookies;
          if ($cookies->get('cookiesaccepted',false)){
            preg_match_all('/"(\w*)"/', $cookies->get('cookiesettings'),$settings);
            if ($settings){
              $return = (in_array($type, $settings[1], TRUE));
            }
          }
        }
        return false;
      }),
    ];
  }
}
