function loadcookie(data) {

    var settings = data;

    // create icons
    var icons = document.createElement('div');

    // create overlay
    var $cookieOptions = document.createElement("div");
    $cookieOptions.classList.add('cookie-options');

    var $cookieOverlay = document.createElement("div");
    $cookieOverlay.classList.add('cookie-overlay', 'fixed', 'cover');
    $cookieOverlay.appendChild($cookieOptions);

    // create message
    var $cookieMessage = document.createElement("div");
    $cookieMessage.classList.add('cookie-message', 'fixed', 'left', 'all-100');

    var $cookieMessageContainer = document.createElement("div");
    $cookieMessageContainer.classList.add('cookie-message-container');

    var $cookieMessageContainerCell = document.createElement("div");
    $cookieMessageContainerCell.classList.add('cookie-message-container-cell');
    $cookieMessageContainerCell.innerHTML = settings.message;

    var bodyElement = document.body;

    if (settings.options.types.length > 0) {
        // check if do not track is set in browser
        var doNotTrack = navigator.doNotTrack == "yes" || navigator.doNotTrack == "1" || window.doNotTrack == "yes" || window.doNotTrack == "1" || navigator.msDoNotTrack == "yes" || navigator.msDoNotTrack == "1";

        // overwrite default setting tracking if do not track is set
        if (doNotTrack) {
            var len = settings.options.types.length;

            for (var i = 0; i < len; i++) {
                if (settings.options.types[i].type == 'tracking') {
                    settings.options.types[i].allowCookie = false;
                    settings.options.types[i].optionEnabled = false;
                }
            }
        }

        // create options button
        var $optionsAnchor = document.createElement("a");
        var optionsLabel = document.createTextNode(settings.settingsLabel);
        $optionsAnchor.classList.add('settings');
        $optionsAnchor.appendChild(optionsLabel);
        $optionsAnchor.onclick = function(event){
            event.preventDefault();
            showCookieSettings();
        };

        var $optionsLinks = document.getElementsByClassName('cookiesettings');

        for (var i = 0; i < $optionsLinks.length; i++) {
            $optionsLinks[i].onclick = function(event) {
                event.preventDefault();
                showCookieSettings();
            }
        };

        // options
        var cookieSettings = getSettings();

        if (cookieSettings != null) {
            var len = settings.options.types.length;
            var len2 = cookieSettings.length;

            for (var i = 0; i < len; i++) {
                settings.options.types[i].allowCookie = false;

                for (var j = 0; j < len2; j++) {
                    if (settings.options.types[i].type == cookieSettings[j]) {
                        settings.options.types[i].allowCookie = true;
                    }
                }
            }
        }

        var options = settings.options;
        var cookiesAccepted = getCookie('cookiesaccepted') == null ? false : true;

        if (cookiesAccepted == false && settings.saveOnOpen) {
            saveSettings(false);
            dataLayer.push({"event":"gtmCookieTriggers"});
        } else {
            if (cookiesAccepted == true) {
                dataLayer.push({"event":"gtmCookieTriggers"});
            }
        }

        insertOptions(options);
    }

    // don't show the cookie bar if the cookie settings are already set
    if (cookiesAccepted == false) {
        // create accept button
        var $acceptAnchor = document.createElement("a");
        var acceptLabel = document.createTextNode(settings.acceptLabel);
        $acceptAnchor.classList.add('ara-button');
        $acceptAnchor.appendChild(acceptLabel);
        $acceptAnchor.onclick = function (event) {
            $cookieMessage.classList.add('closed');
            saveSettings(true);
        };

        // create close button
        var $closeCookieButton = document.createElement("div");
        $closeCookieButton.classList.add('close');
        $closeCookieButton.innerHTML = '<div class="bar"></div><div class="bar"></div>';
        $closeCookieButton.onclick = function (event) {
          $cookieMessage.classList.add('closed');
          saveSettings(true);
        };

        // create actions bar
        var $cookieActions = document.createElement("div");
        $cookieActions.classList.add('actions');
        if (settings.options.types.length > 0) {
            $cookieActions.appendChild($optionsAnchor);
        }
        $cookieActions.appendChild($acceptAnchor);
        $cookieActions.appendChild($closeCookieButton);

        // add actions bar and text message to cookiemessage
        $cookieMessageContainer.appendChild($cookieMessageContainerCell);
        $cookieMessageContainer.appendChild($cookieActions);
        $cookieMessage.appendChild($cookieMessageContainer);

        // add cookie bar to container
        bodyElement.insertBefore($cookieMessage, bodyElement.firstChild);
    }

    bodyElement.insertBefore($cookieOverlay, bodyElement.firstChild);

    function showCookieSettings()
    {
        $cookieOverlay.style.zIndex = "99999";
        setTimeout(function(){
            $cookieOverlay.classList.add('show');
            $cookieOptions.classList.add('show');
        }, 50);
    }

    function insertOptions(options) {
        // title
        var h2 = document.createElement("h2");
        var strong = document.createElement("strong");
        var optionsTitle = document.createTextNode(options.title);
        var optionstitleDivider = document.createTextNode(' | ');
        var optionsDescription = document.createTextNode(options.description);

        strong.appendChild(optionsTitle);
        h2.appendChild(strong);
        h2.appendChild(optionstitleDivider);
        h2.appendChild(optionsDescription);

        // closebutton
        var closeOverlay = document.createElement("div");
        closeOverlay.className = "close";
        closeOverlay.innerHTML = '<div class="bar"></div><div class="bar"></div>';
        closeOverlay.onclick = function(e){
            $cookieOverlay.classList.remove('show');
            $cookieOptions.classList.remove('show');
            setTimeout(function(){
                $cookieOverlay.style.zIndex = "-1";
            }, 500);

            // if cookie settings are set earlier, change them immediately
            if (cookiesAccepted == true) {
                saveSettings(true);
            }
        };

        // header
        var header = document.createElement("header");
        header.appendChild(h2);
        header.appendChild(closeOverlay);

        // nav
        var optionsNav = document.createElement("nav");
        var optionsUl = document.createElement("ul");
        var optionDescriptions = document.createElement("div");
        optionDescriptions.classList.add('descriptions');

        var i = 0;
        var len = options.types.length;
        for (; i < len; ) {
            var option = options.types[i];
            var active = (i == 0 ? "active" : "");

            // text nodes
            var optionListTitle = document.createTextNode(option.title);

            // build li
            var optionLi = document.createElement("li");
            optionLi.className = active;
            optionLi.appendChild(optionListTitle);

            // add to li object
            option.tab = optionLi;

            // add listener to li
            addTabListener(option);

            // add li to ul
            optionsUl.appendChild(optionLi);

            // build description div
            var optionDescription = document.createElement("div");

            // add text
            var optionDescTitle = document.createTextNode(option.title);
            var optionDescText = document.createTextNode(option.description);
            var optionTextBlock = document.createElement("div");
            var optionTextBlockP = document.createElement("p");
            var optionTextBlockH3 = document.createElement("h3");

            optionTextBlockH3.appendChild(optionDescTitle);
            optionTextBlockP.appendChild(optionDescText);

            optionTextBlock.classList.add('text');
            optionTextBlock.appendChild(optionTextBlockH3);
            optionTextBlock.appendChild(optionTextBlockP);

            // add switch

            if (option.optionEnabled == true) {
                var optionSwitch = document.createElement("div");
                optionSwitch.classList.add('switch');

                if (option.allowCookie) {
                    optionSwitch.classList.add('on');
                } else {
                    optionSwitch.classList.add('off');
                }

                // add switch to object
                option.switch = optionSwitch;

                // add listener function to switch
                addSwitchListener(option);

                optionDescription.appendChild(optionSwitch);
            }

            // wrap up the option description
            optionDescription.appendChild(optionTextBlock);
            optionDescription.classList.add('description');

            if (active !== '') {
                optionDescription.classList.add(active);
            }

            // add description to object
            option.body = optionDescription;

            // add description to descriptions
            optionDescriptions.appendChild(optionDescription);

            i++;
        }

        optionsNav.appendChild(optionsUl);

        // finally: build Cookie options
        $cookieOptions.appendChild(header);
        $cookieOptions.appendChild(optionsNav);
        $cookieOptions.appendChild(optionDescriptions);

        // functions
        function addTabListener(option) {
            option.tab.onclick = function(){
                var i = 0;
                var len = options.types.length;
                for (; i < len; ) {
                    var item = options.types[i];
                    item.tab.classList.remove('active');
                    item.body.classList.remove('active');
                    i++;
                }
                option.tab.classList.add('active');
                option.body.classList.add('active');
            };
        };

        function addSwitchListener(option) {
            option.switch.onclick = function() {
                if (option.allowCookie) {
                    option.switch.classList.remove('on');
                    option.switch.classList.add('off');
                    option.allowCookie = false;
                } else {
                    option.switch.classList.remove('off');
                    option.switch.classList.add('on');
                    option.allowCookie = true;
                };
            }
        }
    }

    function saveSettings(accepted) {
        var cookieTypes = new Array();
        var len = options.types.length;

        for (var i = 0; i < len; i++) {
            var option = options.types[i];

            if (option.allowCookie) {
                cookieTypes.push(option.type);
            }
        }

        var value = JSON.stringify(cookieTypes);

        setCookie('cookiesettings', value, 120);

        if (accepted == true) {
            if (cookiesAccepted == false) {
                setCookie('cookiesaccepted', 'true', 120);
            }

            if (settings.reloadAfterSave) {
                window.location = location;
            } else {
                if (settings.triggerAfterAgree) {
                    dataLayer.push({"event": "gtmCookieTriggers"});
                }
            }
        }
    };

    function getSettings() {
        var nameEQ = "cookiesettings=";
        var ca = document.cookie.split(';');

        for(var i=0;i < ca.length;i++) {
            var c = ca[i];
            while (c.charAt(0) === ' ') {
                c = c.substring(1,c.length);
            }
            if (c.indexOf(nameEQ) === 0) {
                return JSON.parse(c.substring(nameEQ.length,c.length));
            }
        }
        return null;
    }

    function clearSettings() {
        setCookie('cookiesettings',"",-1);
    }

    function setCookie(name, value, days) {
        if (days) {
            var date = new Date();
            date.setTime(date.getTime()+(days*24*60*60*1000));
            var expires = "; expires="+date.toGMTString();
        } else {
            var expires = "";
        }

        document.cookie = name+"="+value+expires+"; path=/; SameSite=None; Secure;";
    }

    function getCookie(cname) {
        var name = cname + "=";
        var decodedCookie = decodeURIComponent(document.cookie);
        var ca = decodedCookie.split(';');
        for(var i = 0; i <ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) == ' ') {
                c = c.substring(1);
            }
            if (c.indexOf(name) == 0) {
                return c.substring(name.length, c.length);
            }
        }
        return null;
    }
}
if (typeof _cc_gtm_code !== 'undefined'){
  (function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
      new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
    j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
    'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
  })(window,document,'script','dataLayer',_cc_gtm_code);
}
